/********************************** (C) COPYRIGHT *******************************
* File Name          : USBH_DEAL.H
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/10
* Description        : USBͷļ
*******************************************************************************/



#ifndef __USBH_DEAL_H__
#define __USBH_DEAL_H__

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/
/* ͷļ */
#include "MAIN.H"	 															/* ͷļ */

/********************************************************************************/
/* غ궨 */
#define DEF_COM_BUF_LEN	   		   600											/* USBͨûܳ */	
#define DEF_USBD_DESC_BUF_LEN	   1536											/* USB豸ܳ */	

/* : HUB˿ں0/1/2	*/
/* : 0-ʧ, 0x31-ɹöٵUSB, 0x32-ɹöٵ, 0x70-ɹöٵӡ, 0x80-ɹöٵU, 0xFF-ɹöδ֪豸, ֵδ */
#define	DEV_ERROR		0x00
#define	DEV_KEYBOARD	0x31
#define	DEV_MOUSE		0x32
#define	DEV_PRINT		0x70
#define	DEV_DISK		0x80
#define	DEV_HUB			0x90
#define	DEV_UNKNOWN		0xFF

/************************************************/
/* USB豸Ϣؽṹ嶨 */
struct USBD_DESC_INFO
{
	UINT16 Desc_Total;															/* ǰUSB豸ܳ */
	UINT16 Base_Offset;															/* ǰUSB豸ƫƻַ */
	UINT16 Dev_Offset;															/* USB豸ƫƵַ */
	UINT16 Dev_Len;																/* USB豸 */
	UINT16 Cfg_Offset;															/* USBƫƵַ */
	UINT16 Cfg_Len;																/* USB */
	UINT16 Hid1_Offset;															/* USB HID1ƫƵַ */
	UINT16 Hid1_Len;															/* USB HID1 */
	UINT16 Hid2_Offset;															/* USB HID2ƫƵַ */
	UINT16 Hid2_Len;															/* USB HID2 */
	UINT16 Hid3_Offset;															/* USB HID3ƫƵַ */
	UINT16 Hid3_Len;															/* USB HID3 */
	UINT16 Hid4_Offset;															/* USB HID4ƫƵַ */
	UINT16 Hid4_Len;															/* USB HID4 */
	UINT16 Hid5_Offset;															/* USB HID5ƫƵַ */
	UINT16 Hid5_Len;															/* USB HID5 */	
	UINT16 Str1_Offset;															/* USBַ1ƫƵַ */
	UINT16 Str1_Len;															/* USBַ1 */
	UINT16 Str2_Offset;															/* USBַ2ƫƵַ */
	UINT16 Str2_Len;															/* USBַ2 */
	UINT16 Str3_Offset;															/* USBַ3ƫƵַ */
	UINT16 Str3_Len;															/* USBַ3 */
	UINT16 Str4_Offset;															/* USBַ4ƫƵַ */
	UINT16 Str4_Len;															/* USBַ4 */	
};

/************************************************/
/* USB˿µĵ豸ӿ */
#define DEF_INTERFACE_NUM_MAX       4

/* USBؽṹ */
struct __HOST_CTL
{
	UINT8  InterfaceNum;             											/* USB豸ӿ */	
	UINT8  HubInAddr;		 													/* HUB˵ַ */
	UINT8  ErrorCount;															/* 豸쳣 */

	/* ӿر */
	struct interface
	{
		UINT8  Type;         													/* ýӿ(̡ꡢý) */
		UINT16 HidDescLen;          											/* ýӿHID */
		UINT8  HidReportID;            											/* HID Report ID */ 
		UINT8  Full_KB_Flag;													/* ȫģʽ־ */

        UINT8  InEndpNum;                                                       /* ýӿ˵ */   		
		UINT8  InEndpAddr[ 4 ];       											/* ýӿ˵ */
		UINT8  InEndpType[ 4 ];       											/* ýӿ˵ */ 
		UINT16 InEndpSize[ 4 ];       											/* ýӿ˵С */ 
		UINT8  InEndpTog[ 4 ];         											/* ýӿ˵ͬ־λ */
		UINT8  InEndpInterval[ 4 ];												/* ýӿ˵ѯʱ */
		UINT8  InEndpTimeCount[ 4 ];											/* ýӿ˵ʱ */
		
        UINT8  OutEndpNum;                                                      /* ýӿ˵ */  
		UINT8  OutEndpAddr[ 4 ];        										/* ýӿ˵ */
		UINT8  OutEndpType[ 4 ];       											/* ýӿ˵ */ 
		UINT16 OutEndpSize[ 4 ];       											/* ýӿ˵С */ 
		UINT8  OutEndpTog[ 4 ];         										/* ýӿ˵ͬ־λ */
        
		UINT8  NoSetReport_Flag;												/* SetReport־ */

	}Interface[ DEF_INTERFACE_NUM_MAX ];
};

#define DEC_SUCCESS          	   0x40           
#define DEC_RESET           	   0x41            
#define DEC_DISCONNECT             0x42           
#define DEC_DESCR_UNKNOW           0x43           
#define DEC_ERROR		           0x44           
#define DEC_DESCR_GETFAIL          0x45          
#define DEC_BUF_OVERFLOW           0x46          

/************************************************/
/* Ͷ */
#define DEF_DECR_CONFIG			   0x02  										/*  */
#define DEF_DECR_INTERFACE		   0x04  										/* ӿ */
#define DEF_DECR_ENDPOINT		   0x05 	 									/* ˵ */
#define DEF_DECR_HID			   0x21  										/* HID */

/************************************************/
/* USB豸ӿ */
#define DEC_KEY             	   0x01           								/* USB豸 */
#define DEC_MOUSE           	   0x02           								/* USB豸 */
#define DEC_UNKNOW         		   0xFF           								/* 豸δ֪ */

/******************************************************************************/
/*  */
extern UINT8  Com_Buf[ DEF_COM_BUF_LEN ];										/* ͨû */								
extern UINT8  USBD_DevDesc_Buf[ 18 ];											/* USB豸 */
extern UINT8  USBD_AllDesc_Buf[ DEF_USBD_DESC_BUF_LEN ];						/* USB豸 */
extern struct USBD_DESC_INFO USBD_Desc[ 3 ];									/* USB豸Ϣؽṹ */
extern struct __HOST_CTL HostCtl[ 4 ]; 											/* USB豸ؽṹ */

extern UINT8V  USBH_ReadyTimer;													/* USB⵽豸ȶʱ */
extern UINT8V  USBH_ResetTimer;													/* USBֱͨ豸λʱ */

extern UINT8X  HID_SetReport_Last;                                              /* USB SetReportֵ(һ) */  
extern UINT16X Cfg_Desc_Len;                                                    /* USB豸 */


/********************************************************************************/
/*  */
extern void USBH_AnalyseType( UINT8 *pbuf, UINT8 *ptype );						/*  USB򵥷ǰUSB豸 */
extern void USBH_HIDDese_Save( UINT8 index, UINT8 type, UINT8 *pbuf, UINT16 len );/* USB HID豸 */
extern UINT8 USBH_Enum_RootDevice( UINT8 index, UINT8 mode );					/* USBöٸ豸 */
extern UINT8 USBH_Enum_HidDevice( UINT8 portnum, UINT8 dev );				    /* USBöHID豸 */
extern UINT8 USBH_Analyse_CfgDesc( UINT8 index );								/* USBµ豸 */
extern UINT8 KM_Analyse_ConfigDesc( UINT8 index );		 						/* USB */
extern UINT8 KM_Deal_HidReportDesc( UINT8 index, UINT8 dev );					/* ȡHID */
extern UINT8 KM_HostSetReport( UINT8 report );									/* USBUSB̷SetReport */	
extern UINT8 USBH_Get_HidData( UINT8 index, UINT8 intfnum, UINT8 endpnum, UINT8 *pbuf, UINT8 *plen ); /* USBȡUSB HID豸 */
extern UINT8 USBH_Main_Deal( void );											/* USB */
extern UINT8 USBX_ThisHub_EP1IntUp( UINT8 portbit );
extern UINT8 USBX_OneHub_EP1IntUp( UINT8 pcx, UINT8 index, UINT8 status );
extern void USBX_AllHub_EP1IntUp( UINT8 index, UINT8 status );

#ifdef __cplusplus
}
#endif

#endif

/*********************************END OF FILE**********************************/
